#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 5.4.2 (swiftlang-1205.0.28.2 clang-1205.0.19.57)
#ifndef FLYBITSSDK_SWIFT_H
#define FLYBITSSDK_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#include <Foundation/Foundation.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="FlybitsSDK",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

@class NSString;
enum HTTPMethod : NSInteger;
@class User;

/// The <code>IDP</code> protocol defines Identity Providers (IDP) supported by Flybits.
SWIFT_PROTOCOL("_TtP10FlybitsSDK3IDP_")
@protocol IDP <NSCoding>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
@optional
/// The HTTP(s) POST request query parameter(s)
@property (nonatomic, readonly, copy) NSString * _Nullable queryParams;
/// The HTTP(s) Header in case is necessary.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nonnull requestHeaders;
/// The HTTP method in case is necessary to change
@property (nonatomic, readonly) enum HTTPMethod requestMethod;
/// Once Authentication works with the provided IDP this method will get triggered only in success scenario.
/// \param user The returned Flybits user object
///
- (void)didAuthenticateWithUser:(User * _Nonnull)user;
@end

@class NSCoder;

SWIFT_CLASS("_TtC10FlybitsSDK9APIKeyIDP")
@interface APIKeyIDP : NSObject <IDP>
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Base object to be used by any analytics meant to leverage the Flybits Analytics system
SWIFT_CLASS("_TtC10FlybitsSDK14AnalyticsEvent")
@interface AnalyticsEvent : NSObject
/// Do not use this constructor. Use <code>init(analyticsScope:action:value:timestamp)</code> constructor.
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>AnonymousIDP</code> class is responsible for creating an anonymous Flybits account.
SWIFT_CLASS("_TtC10FlybitsSDK12AnonymousIDP")
@interface AnonymousIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Defines all the error that can be return by FlybitsSDK when the cache layer
/// fails or throws exception
typedef SWIFT_ENUM(NSInteger, CacheError, open) {
/// Token not found
  CacheErrorTokenNotFound = 0,
};
static NSString * _Nonnull const CacheErrorDomain = @"FlybitsSDK.CacheError";

/// Defines all the error that can be return by FlybitsSDK when it fails to
/// format server response
typedef SWIFT_ENUM(NSInteger, CocoaError, open) {
/// Formatting error
  CocoaErrorFormattingError = 0,
};
static NSString * _Nonnull const CocoaErrorDomain = @"FlybitsSDK.CocoaError";

/// Defines all the error that can be return by FlybitsSDK when the cache store
/// fails or throws exception
typedef SWIFT_ENUM(NSInteger, CoreDataError, open) {
/// Store not found
  CoreDataErrorStoreNotFound = 0,
};
static NSString * _Nonnull const CoreDataErrorDomain = @"FlybitsSDK.CoreDataError";

/// Enum <code>CustomerStatus</code> with all possible status for the local user information.
typedef SWIFT_ENUM(NSInteger, CustomerStatus, open) {
/// Not possible to determine the status of the user
  CustomerStatusUnknown = 0,
/// User is connected and opted in
  CustomerStatusActiveOptedIn = 1,
/// User is connected and opted in. However the JWT is expired. New connection is required.
  CustomerStatusActiveOptedInExpiredToken = 2,
/// User is connected but opted out and the JWT is expired. New connection is required.
  CustomerStatusActiveOptedOutExpiredToken = 3,
/// User is connected but opted out.
  CustomerStatusActiveOptedOut = 4,
/// User is not connected but it is opted in.
  CustomerStatusNotActiveOptedIn = 5,
/// User is not connected but it is opted out.
  CustomerStatusNotActiveOptedOut = 6,
};


SWIFT_CLASS("_TtC10FlybitsSDK13DeviceManager")
@interface DeviceManager : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Defines errors that contains list of other errors. You should inspect the error’s userInfo to see other errors
typedef SWIFT_ENUM(NSInteger, ErrorList, open) {
/// Array
  ErrorListArray = 0,
};
static NSString * _Nonnull const ErrorListDomain = @"FlybitsSDK.ErrorList";


/// The <code>FlyJWT</code> class handles refreshing of token with the Flybits server.
SWIFT_CLASS("_TtC10FlybitsSDK6FlyJWT")
@interface FlyJWT : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class FlybitsRequest;

SWIFT_CLASS("_TtC10FlybitsSDK16FlybitsAnalytics")
@interface FlybitsAnalytics : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
+ (FlybitsRequest * _Nullable)sendAnalyticsWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
@end


@class NSNumber;

/// The <code>FlybitsScope</code> protocol defines an SDK scope that enables or disables various capabilities
/// available through the SDKs.
/// Flybits modular SDKs are responsible for implementing the scope and define available functionality.
SWIFT_PROTOCOL("_TtP10FlybitsSDK12FlybitsScope_")
@protocol FlybitsScope <NSCoding>
/// Indicates that the scope has been added and appropriate actions
/// can be performed by the SDKs.
/// \param currentActiveUserIsOptedIn Indicates if the current active user is opted in. False if there is no active user.
///
- (void)onStartWithCurrentActiveUserIsOptedIn:(BOOL)currentActiveUserIsOptedIn;
/// Indicates that the scope has been removed and appropriate actions
/// can be performed by the SDKs.
- (void)onStop;
/// Indicates that the connection was successfully made and appropriate actions
/// can be performed by the SDKs.
/// \param user The connected <code>User</code>.
///
- (void)onConnectedWithUser:(User * _Nonnull)user;
/// Indicates that the disconnection was successfully made and appropriate actions
/// can be performed by the SDKs.
- (void)onDisconnected;
/// Indicates that the account has been opt in successfully and appropriate actions
/// can be performed by the SDKs.
- (void)onOptIn;
/// Indicates that the account has been opt out successfully and appropriate actions
/// can be performed by the SDKs.
- (void)onOptOut;
/// Uniquely identify the scope
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
@end


@interface FlybitsAnalytics (SWIFT_EXTENSION(FlybitsSDK)) <FlybitsScope>
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
- (void)onStartWithCurrentActiveUserIsOptedIn:(BOOL)currentActiveUserIsOptedIn;
- (void)onStop;
- (void)onConnectedWithUser:(User * _Nonnull)user;
- (void)onDisconnected;
- (void)onOptIn;
- (void)onOptOut;
@end

@class NSError;

/// The <code>FlybitsManager</code> class is a primary integration point for all SDKs
/// and is responsible for defining all <code>FlybitsScope</code>’s as well as
/// performing <code>User</code> operations such as logging in, logging out, disabling account,
/// resetting password and refreshing the JWT token.
SWIFT_CLASS("_TtC10FlybitsSDK14FlybitsManager")
@interface FlybitsManager : NSObject <NSCoding>
/// The <code>isConnected</code> method is responsible for checking if the user has already connected.
///
/// returns:
/// A boolean indicating if the user is connected.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL isConnected;)
+ (BOOL)isConnected SWIFT_WARN_UNUSED_RESULT;
/// The <code>currentActiveUserIsOptedIn</code> method is responsible for checking if the current active user is opted in.
///
/// returns:
/// A boolean indicating if the current active user is opted in. If there is no active user, also returns false.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL currentActiveUserIsOptedIn;)
+ (BOOL)currentActiveUserIsOptedIn SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// The <code>connect</code> method is responsible for connecting the identity provider to Flybits.
/// On successful connection, all registered <code>FlybitsScope</code>’s gets notified
/// through the <code>onConnected</code> method.
/// When using <code>FlybitsIDP</code> and requiring account activation, appropriate error codes gets returned
/// indicating if confirmation email was sent successfully i.e. <code>RegistrationError.confirmationRequired</code>
/// or if error occured when sending confirmation email i.e. <code>RegistrationError.failedSendingConfirmationEmail</code>.
/// There is only a single session being persisted at any time. Use the <code>customerId</code> field to help discover which
/// user is currently known by the SDK and if a connect is needed to swap.
/// warning:
/// This method will return an error in case you don’t disconnect a previous connection beforehand try to connect again.
/// \param completion A completion closure that returns the connected <code>User</code> on success or an <code>NSError</code> if failed.
///
/// \param idp The authentication object for the user
///
/// \param user The returned Flybits user object
///
/// \param customerId An application unique identifier associated with the newly created flybits session.
///
/// \param error Contains failed authentication result
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object. In the case of already an alive connection, it will be nil.
+ (FlybitsRequest * _Nullable)connectWithIDP:(id <IDP> _Nonnull)idp customerId:(NSString * _Nullable)customerId physicalDeviceId:(NSString * _Nullable)physicalDeviceId completion:(void (^ _Nonnull)(User * _Nullable, NSError * _Nullable))completion;
/// The <code>disconnect</code> method is responsible for disconnecting and clearing the session with Flybits.
/// On successfully disconnecting, all registered <code>FlybitsScope</code>’s gets notified
/// through the <code>onDisconnected</code> method.
/// \param completion A completion closure that returns nil on success or an <code>NSError</code> if failed.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)disconnectWithCompletion:(void (^ _Nonnull)(NSError * _Nullable))completion;
+ (void)enableLogging;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)decoder;
@end


@interface FlybitsManager (SWIFT_EXTENSION(FlybitsSDK))
/// Verify the <code>CustomerStatus</code> of the current user based on the provided customer identification.
/// \param customerId App’s customer identification
///
///
/// returns:
/// The enum <code>CustomerStatus</code> case based on the provided customer identification provided.
+ (enum CustomerStatus)statusFor:(NSString * _Nonnull)customerId SWIFT_WARN_UNUSED_RESULT;
@end


/// The <code>FlybitsPreference</code> class is responsible for storing key-pair values on the Flybits
/// server to act as preferences for the user. These preferences are saved on a per user basis
/// regardless of the device.
SWIFT_CLASS("_TtC10FlybitsSDK17FlybitsPreference")
@interface FlybitsPreference : NSObject
/// Set the object associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The object that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSDictionary<NSString *, id> * _Nonnull)value object:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the array preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The array value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSArray * _Nonnull)value array:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the boolean preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The boolean value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(BOOL)value bool:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the string preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The string value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSString * _Nonnull)value string:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the integer preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The integer value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSInteger)value int:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the double precision floating-point preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The double value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(double)value double:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



@class NSURLRequest;
enum FlybitsRequestType : NSInteger;
@class NSHTTPURLResponse;
@class NSData;
@class NSURLResponse;

/// The base Flybits SDKs network request class.
SWIFT_CLASS("_TtC10FlybitsSDK14FlybitsRequest")
@interface FlybitsRequest : NSObject
/// Constructs a new request based on an NSURLRequest.
/// \param request An NSURLRequest object.
///
- (nonnull instancetype)initWithRequest:(NSURLRequest * _Nullable)request requestType:(enum FlybitsRequestType)type isCachable:(BOOL)isCachable error:(NSError * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Sets success status code
- (FlybitsRequest * _Nonnull)setHttpSuccessStatusCode:(NSInteger)httpSuccessStatusCode SWIFT_WARN_UNUSED_RESULT;
/// Sets success status code with lower..<upper bounds
- (FlybitsRequest * _Nonnull)setHttpSuccessStatusCodeWithLowerBound:(NSInteger)lower upperBound:(NSInteger)upper SWIFT_WARN_UNUSED_RESULT;
/// Uses Generics to serialize the server’s response into an object of the specified type.
/// \param completion A closure that returns the original request, the response, the serialized object and an error.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
- (nonnull instancetype)responseWithCompletion:(void (^ _Nonnull)(NSURLRequest * _Nullable, NSHTTPURLResponse * _Nullable, NSData * _Nullable, NSError * _Nullable))completion;
/// Uses the <code>uploadTask</code> to place an operation in the OS to be executed later
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
- (nonnull instancetype)uploadTask:(void (^ _Nonnull)(NSData * _Nullable, NSURLResponse * _Nullable, NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
@end


/// The base Flybits SDK network request list class that handles multiple requests.
SWIFT_CLASS("_TtC10FlybitsSDK18FlybitsRequestList")
@interface FlybitsRequestList : FlybitsRequest
/// Default initializer
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithRequest:(NSURLRequest * _Nullable)request requestType:(enum FlybitsRequestType)type isCachable:(BOOL)isCachable error:(NSError * _Nullable)error SWIFT_UNAVAILABLE;
@end

/// A list of possible request types for a Requestable.
typedef SWIFT_ENUM(NSInteger, FlybitsRequestType, open) {
/// A core request (inherent to Flybits core, i.e. <code>Content</code>, <code>User</code>)
  FlybitsRequestTypeGateway = 0,
/// A rule request (<code>Rule</code> based requests)
  FlybitsRequestTypeRules = 1,
/// A context data update request
  FlybitsRequestTypeContextUpdate = 2,
/// A push request (<code>APNS</code> and <code>MQTT</code> based requests)
  FlybitsRequestTypePush = 3,
/// A custom request
  FlybitsRequestTypeCustom = 4,
};


/// An enum containing different types of request methods. Currently supports <code>GET</code>, <code>POST</code>, <code>PUT</code> and <code>DELETE</code>
typedef SWIFT_ENUM(NSInteger, HTTPMethod, open) {
/// HTTP GET.
  HTTPMethodGET = 0,
/// HTTP POST.
  HTTPMethodPOST = 1,
/// HTTP PUT.
  HTTPMethodPUT = 2,
/// HTTP DELETE.
  HTTPMethodDELETE = 3,
};




/// Defines errors that can occur when fetching a new JWT.
typedef SWIFT_ENUM(NSInteger, JWTError, open) {
/// Max retries
  JWTErrorMaxRetries = 0,
};
static NSString * _Nonnull const JWTErrorDomain = @"FlybitsSDK.JWTError";


/// The <code>JwtIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// can be logged into using the Flybits Token.
SWIFT_CLASS("_TtC10FlybitsSDK6JwtIDP")
@interface JwtIDP : NSObject <IDP>
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// The Request Headers in case any header is necessary to be inserted
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nonnull requestHeaders;
/// Which HTTP method should be used
@property (nonatomic, readonly) enum HTTPMethod requestMethod;
- (void)didAuthenticateWithUser:(User * _Nonnull)user;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>JwtLoginIDP</code> class is responsible for creating an JWT based signed login idnentifier provider (IDP).
/// Using this IDP for customer that need JWT based signed Login indentifier.
/// By using this IDP, customer need to provide a signed JWT.
SWIFT_CLASS("_TtC10FlybitsSDK11JwtLoginIDP")
@interface JwtLoginIDP : NSObject <IDP>
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// Request header need to use jwt signed token
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nonnull requestHeaders;
@property (nonatomic, readonly) enum HTTPMethod requestMethod;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines errors that can occur during localization changes
typedef SWIFT_ENUM(NSInteger, LocalizationError, open) {
/// Unknown language code
  LocalizationErrorUnknownLanguageCode = 0,
/// Invalid format
  LocalizationErrorInvalidFormat = 1,
};
static NSString * _Nonnull const LocalizationErrorDomain = @"FlybitsSDK.LocalizationError";

/// Defines some of the error that can be return by Flybits for login related
/// issues. You might get any of those (SessionError, NetworkingRequestError,
/// CoreDataError, etc) as well as LoginError. <code>NSError.userInfo</code> will
/// tell you what data is missing or invalid.
typedef SWIFT_ENUM(NSInteger, LoginError, open) {
/// Missing field/property that is expected to be there for API to function
  LoginErrorMissingRequiredData = 0,
/// Invalid data is being sent for a property – i.e., sending email not in
/// the correct format, i.e., user@flybits,com (notice the comma).
  LoginErrorInvalidData = 1,
/// User already connected. Disconnect before connecting again.
  LoginErrorAlreadyConnected = 2,
/// No user connected. Connect before disconnecting again.
  LoginErrorNotConnected = 3,
};
static NSString * _Nonnull const LoginErrorDomain = @"FlybitsSDK.LoginError";



/// A structure containing many constants used internally in the SDK
SWIFT_CLASS("_TtC10FlybitsSDK7Network")
@interface Network : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Defines all the error that can be return by FlybitsSDK when request fails
/// for network reason, or internal server issues.
/// Note: NetworkingRequestError.FlybitsUnavailable is used as ‘Kill Switch’
typedef SWIFT_ENUM(NSInteger, NetworkingRequestError, open) {
/// Returned data is not the expected format
  NetworkingRequestErrorUnableToParseResponse = 0,
/// Request made is invalid
  NetworkingRequestErrorInvalidRequest = 400,
/// Kill switch – Flybits is deactivated on purpose
  NetworkingRequestErrorFlybitsUnavailable = 503,
/// You do not have access to call the API – may ProjectID is wrong?
  NetworkingRequestErrorUnauthorized = 401,
/// You do not have access to call the API – Are you logged out?
  NetworkingRequestErrorForbidden = 403,
/// Resource is not found – Invalid data is being post to server? or getting from server?
  NetworkingRequestErrorNotFound = 404,
/// Indicates that the application has exceeded its API usage limit for the project.
  NetworkingRequestErrorApiUsageExceeded = 429,
/// Posting data is empty
  NetworkingRequestErrorEmptyData = 430,
/// By default all http request is expected to be between 200 ..< 300 (HTTP success range)
  NetworkingRequestErrorExpectationNotMet = 431,
};
static NSString * _Nonnull const NetworkingRequestErrorDomain = @"FlybitsSDK.NetworkingRequestError";


/// The <code>OAuthIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// is managed by a OAuth based 3rd party integration such Facebook or Google.
SWIFT_CLASS("_TtC10FlybitsSDK8OAuthIDP")
@interface OAuthIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM(NSInteger, SupportedIDP, open) {
/// Facebook OAuth
  SupportedIDPFacebook = 0,
/// Google OAuth
  SupportedIDPGoogle = 1,
/// Okta OAuth
  SupportedIDPOkta = 2,
};


/// The <code>OpenIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// can be logged into using the Open ID connect protocol.
SWIFT_CLASS("_TtC10FlybitsSDK7OpenIDP")
@interface OpenIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC10FlybitsSDK9Operation")
@interface Operation : NSOperation
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (void)observeValueForKeyPath:(NSString * _Nullable)keyPath ofObject:(id _Nullable)object change:(NSDictionary<NSKeyValueChangeKey, id> * _Nullable)change context:(void * _Nullable)context;
@property (nonatomic, readonly, getter=isReady) BOOL ready;
@property (nonatomic, readonly, getter=isExecuting) BOOL executing;
@property (nonatomic, readonly, getter=isFinished) BOOL finished;
@property (nonatomic, readonly, getter=isCancelled) BOOL cancelled;
- (void)addDependency:(NSOperation * _Nonnull)operation;
- (void)main;
- (void)cancel;
- (void)waitUntilFinished;
@end

enum FlybitsUtilitiesSortBy : NSInteger;
enum FlybitsUtilitiesSortOrder : NSInteger;

/// If there are lot of items to be returned, for performance reason, pagination should be used. Even if you do not indicate pagination, response might be paginated.
/// By setting <code>limit</code> and <code>offset</code>, you can retrieve different “pages” of data. For example, you might want to display first 20 items (experiences/content/etc). So, by using pagination as shown below, you will receive the first 20 items.
/// \code
/// // First 20 items or first page with 20 items
/// let pager = Pager(limit:20, offset:0)
///
/// \endcodeTo get the next page or next 20 items:
/// \code
/// // Second 20 items or second page with 20 items
/// let pager = Pager(limit:20, offset:20)
///
/// \endcode
SWIFT_CLASS("_TtC10FlybitsSDK5Pager")
@interface Pager : NSObject
- (nonnull instancetype)initWithLimit:(NSUInteger)limit offset:(NSUInteger)offset totalRecords:(NSUInteger)totalRecords sortBy:(enum FlybitsUtilitiesSortBy)sortBy sortOrder:(enum FlybitsUtilitiesSortOrder)sortOrder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



/// The <code>Project</code> class represents a specific project information
/// for a registered project with Flybits.
SWIFT_CLASS("_TtC10FlybitsSDK7Project")
@interface Project : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC10FlybitsSDK16PushSubscription")
@interface PushSubscription : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



SWIFT_CLASS("_TtC10FlybitsSDK5Query")
@interface Query : NSObject
/// Override to pretty-print the <code>Query</code>’s debug description.
@property (nonatomic, readonly, copy) NSString * _Nonnull debugDescription;
/// Override to pretty-print the <code>Query</code>’s description.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines errors that can occur when creating query to fetch data from server.
typedef SWIFT_ENUM(NSInteger, QueryExpressionError, open) {
/// Not supported
  QueryExpressionErrorUnsupported = 0,
};
static NSString * _Nonnull const QueryExpressionErrorDomain = @"FlybitsSDK.QueryExpressionError";

/// Defines some of the error that can be return by Flybits when registered
/// new user. You might get any of those (SessionError, NetworkingRequestError,
/// CoreDataError, etc) as well as RegistrationError. <code>NSError.userInfo</code> will
/// tell you what data is missing or invalid.
typedef SWIFT_ENUM(NSInteger, RegistrationError, open) {
/// Missing field/property that is expected to be there for API to function
  RegistrationErrorMissingRequiredData = 0,
/// Invalid data is being sent for a property – i.e., sending email not in
/// the correct format, i.e., user@flybits,com (notice the comma).
  RegistrationErrorInvalidData = 1,
/// The server failed to send a confirmation email.
  RegistrationErrorFailedSendingConfirmationEmail = 2,
/// The user tried logging in but is still required to click the
/// confirmation link in their email.
  RegistrationErrorConfirmationRequired = 3,
};
static NSString * _Nonnull const RegistrationErrorDomain = @"FlybitsSDK.RegistrationError";


/// The <code>SharedElements</code> class is responsible for managing various session based information
/// that can be shared across Flybits SDKs.
SWIFT_CLASS("_TtC10FlybitsSDK14SharedElements")
@interface SharedElements : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



/// The <code>SignedIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// can be logged into using the SAML protocol.
SWIFT_CLASS("_TtC10FlybitsSDK9SignedIDP")
@interface SignedIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines errors that can occur when using toDictionary.
typedef SWIFT_ENUM(NSInteger, ToDictionaryError, open) {
/// Invalid Coordinate
  ToDictionaryErrorInvalidCoordinate = 0,
/// Invalid Dictionary
  ToDictionaryErrorInvalidDictionary = 1,
};
static NSString * _Nonnull const ToDictionaryErrorDomain = @"FlybitsSDK.ToDictionaryError";


/// The <code>User</code> class represents a specific user and is used to store information
/// about a person who has registered an account with Flybits.
SWIFT_CLASS("_TtC10FlybitsSDK4User")
@interface User : NSObject
/// Compares two <code>User</code>s for equality.
/// \param object Another <code>User</code> (<code>NSObject.isEqual()</code> is used if object is not a <code>User</code>).
///
///
/// returns:
/// <code>true</code> if two <code>User</code>s have the same <code>id</code>, <code>false</code> otherwise.
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// The <code>User</code>’s hash value (used when treated as an <code>NSObject</code>).
@property (nonatomic, readonly) NSUInteger hash;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>UserPreference</code> class represents an object that is used to store user-scoped information
SWIFT_CLASS("_TtC10FlybitsSDK14UserPreference")
@interface UserPreference : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A set of utilities to access common iOS properties.
SWIFT_CLASS_NAMED("Utilities")
@interface FlybitsUtilities : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface FlybitsUtilities (SWIFT_EXTENSION(FlybitsSDK))
@end

/// Sort order allows to sort Content based on different fields.
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesSortOrder, "SortOrder", open) {
/// Results should be sorted in <code>Ascending</code> order
  FlybitsUtilitiesSortOrderAscending = 0,
/// Results should be sorted in <code>Descending</code> order
  FlybitsUtilitiesSortOrderDescending = 1,
};

/// Sort by allows to sort and order Content based on different fields.
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesSortBy, "SortBy", open) {
/// Results should be ordered by Content’s priority index
  FlybitsUtilitiesSortByPriority = 0,
/// Results should be ordered by the time the Content associated rule was last evaluated
  FlybitsUtilitiesSortByEvaluatedAt = 1,
/// Results should be ordered by the time the Content was created
  FlybitsUtilitiesSortByCreatedAt = 2,
/// Results should be ordered by the time the Content was last modified
  FlybitsUtilitiesSortByModifiedAt = 3,
};

/// Length units
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesLengthUnit, "LengthUnit", open) {
/// Units in meters
  FlybitsUtilitiesLengthUnitMeters = 0,
/// Units in miles
  FlybitsUtilitiesLengthUnitMiles = 1,
/// Units in kilometers
  FlybitsUtilitiesLengthUnitKilometers = 2,
/// Units in yards
  FlybitsUtilitiesLengthUnitYards = 3,
/// Units in feet
  FlybitsUtilitiesLengthUnitFeet = 4,
};

/// Time units
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesTimeUnit, "TimeUnit", open) {
/// Seconds unit
  FlybitsUtilitiesTimeUnitSeconds = 1,
/// Minutes unit
  FlybitsUtilitiesTimeUnitMinutes = 60,
/// Hours unit
  FlybitsUtilitiesTimeUnitHours = 3600,
/// Days unit
  FlybitsUtilitiesTimeUnitDays = 86400,
};

#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#elif defined(__x86_64__) && __x86_64__
// Generated by Apple Swift version 5.4.2 (swiftlang-1205.0.28.2 clang-1205.0.19.57)
#ifndef FLYBITSSDK_SWIFT_H
#define FLYBITSSDK_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#include <Foundation/Foundation.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="FlybitsSDK",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

@class NSString;
enum HTTPMethod : NSInteger;
@class User;

/// The <code>IDP</code> protocol defines Identity Providers (IDP) supported by Flybits.
SWIFT_PROTOCOL("_TtP10FlybitsSDK3IDP_")
@protocol IDP <NSCoding>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
@optional
/// The HTTP(s) POST request query parameter(s)
@property (nonatomic, readonly, copy) NSString * _Nullable queryParams;
/// The HTTP(s) Header in case is necessary.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nonnull requestHeaders;
/// The HTTP method in case is necessary to change
@property (nonatomic, readonly) enum HTTPMethod requestMethod;
/// Once Authentication works with the provided IDP this method will get triggered only in success scenario.
/// \param user The returned Flybits user object
///
- (void)didAuthenticateWithUser:(User * _Nonnull)user;
@end

@class NSCoder;

SWIFT_CLASS("_TtC10FlybitsSDK9APIKeyIDP")
@interface APIKeyIDP : NSObject <IDP>
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Base object to be used by any analytics meant to leverage the Flybits Analytics system
SWIFT_CLASS("_TtC10FlybitsSDK14AnalyticsEvent")
@interface AnalyticsEvent : NSObject
/// Do not use this constructor. Use <code>init(analyticsScope:action:value:timestamp)</code> constructor.
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>AnonymousIDP</code> class is responsible for creating an anonymous Flybits account.
SWIFT_CLASS("_TtC10FlybitsSDK12AnonymousIDP")
@interface AnonymousIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Defines all the error that can be return by FlybitsSDK when the cache layer
/// fails or throws exception
typedef SWIFT_ENUM(NSInteger, CacheError, open) {
/// Token not found
  CacheErrorTokenNotFound = 0,
};
static NSString * _Nonnull const CacheErrorDomain = @"FlybitsSDK.CacheError";

/// Defines all the error that can be return by FlybitsSDK when it fails to
/// format server response
typedef SWIFT_ENUM(NSInteger, CocoaError, open) {
/// Formatting error
  CocoaErrorFormattingError = 0,
};
static NSString * _Nonnull const CocoaErrorDomain = @"FlybitsSDK.CocoaError";

/// Defines all the error that can be return by FlybitsSDK when the cache store
/// fails or throws exception
typedef SWIFT_ENUM(NSInteger, CoreDataError, open) {
/// Store not found
  CoreDataErrorStoreNotFound = 0,
};
static NSString * _Nonnull const CoreDataErrorDomain = @"FlybitsSDK.CoreDataError";

/// Enum <code>CustomerStatus</code> with all possible status for the local user information.
typedef SWIFT_ENUM(NSInteger, CustomerStatus, open) {
/// Not possible to determine the status of the user
  CustomerStatusUnknown = 0,
/// User is connected and opted in
  CustomerStatusActiveOptedIn = 1,
/// User is connected and opted in. However the JWT is expired. New connection is required.
  CustomerStatusActiveOptedInExpiredToken = 2,
/// User is connected but opted out and the JWT is expired. New connection is required.
  CustomerStatusActiveOptedOutExpiredToken = 3,
/// User is connected but opted out.
  CustomerStatusActiveOptedOut = 4,
/// User is not connected but it is opted in.
  CustomerStatusNotActiveOptedIn = 5,
/// User is not connected but it is opted out.
  CustomerStatusNotActiveOptedOut = 6,
};


SWIFT_CLASS("_TtC10FlybitsSDK13DeviceManager")
@interface DeviceManager : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Defines errors that contains list of other errors. You should inspect the error’s userInfo to see other errors
typedef SWIFT_ENUM(NSInteger, ErrorList, open) {
/// Array
  ErrorListArray = 0,
};
static NSString * _Nonnull const ErrorListDomain = @"FlybitsSDK.ErrorList";


/// The <code>FlyJWT</code> class handles refreshing of token with the Flybits server.
SWIFT_CLASS("_TtC10FlybitsSDK6FlyJWT")
@interface FlyJWT : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class FlybitsRequest;

SWIFT_CLASS("_TtC10FlybitsSDK16FlybitsAnalytics")
@interface FlybitsAnalytics : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
+ (FlybitsRequest * _Nullable)sendAnalyticsWithCompletion:(void (^ _Nullable)(NSError * _Nullable))completion;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
@end


@class NSNumber;

/// The <code>FlybitsScope</code> protocol defines an SDK scope that enables or disables various capabilities
/// available through the SDKs.
/// Flybits modular SDKs are responsible for implementing the scope and define available functionality.
SWIFT_PROTOCOL("_TtP10FlybitsSDK12FlybitsScope_")
@protocol FlybitsScope <NSCoding>
/// Indicates that the scope has been added and appropriate actions
/// can be performed by the SDKs.
/// \param currentActiveUserIsOptedIn Indicates if the current active user is opted in. False if there is no active user.
///
- (void)onStartWithCurrentActiveUserIsOptedIn:(BOOL)currentActiveUserIsOptedIn;
/// Indicates that the scope has been removed and appropriate actions
/// can be performed by the SDKs.
- (void)onStop;
/// Indicates that the connection was successfully made and appropriate actions
/// can be performed by the SDKs.
/// \param user The connected <code>User</code>.
///
- (void)onConnectedWithUser:(User * _Nonnull)user;
/// Indicates that the disconnection was successfully made and appropriate actions
/// can be performed by the SDKs.
- (void)onDisconnected;
/// Indicates that the account has been opt in successfully and appropriate actions
/// can be performed by the SDKs.
- (void)onOptIn;
/// Indicates that the account has been opt out successfully and appropriate actions
/// can be performed by the SDKs.
- (void)onOptOut;
/// Uniquely identify the scope
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
@end


@interface FlybitsAnalytics (SWIFT_EXTENSION(FlybitsSDK)) <FlybitsScope>
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
- (void)onStartWithCurrentActiveUserIsOptedIn:(BOOL)currentActiveUserIsOptedIn;
- (void)onStop;
- (void)onConnectedWithUser:(User * _Nonnull)user;
- (void)onDisconnected;
- (void)onOptIn;
- (void)onOptOut;
@end

@class NSError;

/// The <code>FlybitsManager</code> class is a primary integration point for all SDKs
/// and is responsible for defining all <code>FlybitsScope</code>’s as well as
/// performing <code>User</code> operations such as logging in, logging out, disabling account,
/// resetting password and refreshing the JWT token.
SWIFT_CLASS("_TtC10FlybitsSDK14FlybitsManager")
@interface FlybitsManager : NSObject <NSCoding>
/// The <code>isConnected</code> method is responsible for checking if the user has already connected.
///
/// returns:
/// A boolean indicating if the user is connected.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL isConnected;)
+ (BOOL)isConnected SWIFT_WARN_UNUSED_RESULT;
/// The <code>currentActiveUserIsOptedIn</code> method is responsible for checking if the current active user is opted in.
///
/// returns:
/// A boolean indicating if the current active user is opted in. If there is no active user, also returns false.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) BOOL currentActiveUserIsOptedIn;)
+ (BOOL)currentActiveUserIsOptedIn SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// The <code>connect</code> method is responsible for connecting the identity provider to Flybits.
/// On successful connection, all registered <code>FlybitsScope</code>’s gets notified
/// through the <code>onConnected</code> method.
/// When using <code>FlybitsIDP</code> and requiring account activation, appropriate error codes gets returned
/// indicating if confirmation email was sent successfully i.e. <code>RegistrationError.confirmationRequired</code>
/// or if error occured when sending confirmation email i.e. <code>RegistrationError.failedSendingConfirmationEmail</code>.
/// There is only a single session being persisted at any time. Use the <code>customerId</code> field to help discover which
/// user is currently known by the SDK and if a connect is needed to swap.
/// warning:
/// This method will return an error in case you don’t disconnect a previous connection beforehand try to connect again.
/// \param completion A completion closure that returns the connected <code>User</code> on success or an <code>NSError</code> if failed.
///
/// \param idp The authentication object for the user
///
/// \param user The returned Flybits user object
///
/// \param customerId An application unique identifier associated with the newly created flybits session.
///
/// \param error Contains failed authentication result
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object. In the case of already an alive connection, it will be nil.
+ (FlybitsRequest * _Nullable)connectWithIDP:(id <IDP> _Nonnull)idp customerId:(NSString * _Nullable)customerId physicalDeviceId:(NSString * _Nullable)physicalDeviceId completion:(void (^ _Nonnull)(User * _Nullable, NSError * _Nullable))completion;
/// The <code>disconnect</code> method is responsible for disconnecting and clearing the session with Flybits.
/// On successfully disconnecting, all registered <code>FlybitsScope</code>’s gets notified
/// through the <code>onDisconnected</code> method.
/// \param completion A completion closure that returns nil on success or an <code>NSError</code> if failed.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)disconnectWithCompletion:(void (^ _Nonnull)(NSError * _Nullable))completion;
+ (void)enableLogging;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)decoder;
@end


@interface FlybitsManager (SWIFT_EXTENSION(FlybitsSDK))
/// Verify the <code>CustomerStatus</code> of the current user based on the provided customer identification.
/// \param customerId App’s customer identification
///
///
/// returns:
/// The enum <code>CustomerStatus</code> case based on the provided customer identification provided.
+ (enum CustomerStatus)statusFor:(NSString * _Nonnull)customerId SWIFT_WARN_UNUSED_RESULT;
@end


/// The <code>FlybitsPreference</code> class is responsible for storing key-pair values on the Flybits
/// server to act as preferences for the user. These preferences are saved on a per user basis
/// regardless of the device.
SWIFT_CLASS("_TtC10FlybitsSDK17FlybitsPreference")
@interface FlybitsPreference : NSObject
/// Set the object associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The object that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSDictionary<NSString *, id> * _Nonnull)value object:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the array preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The array value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSArray * _Nonnull)value array:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the boolean preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The boolean value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(BOOL)value bool:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the string preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The string value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSString * _Nonnull)value string:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the integer preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The integer value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(NSInteger)value int:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
/// Set the double precision floating-point preference associated to the <code>key</code> parameter. If a user preferences object does not exist already one will be created.
/// \param value The double value that will be saved.
///
/// \param forKey The attribute name that the preference is saved under.
///
/// \param completion A completion closure that returns an error if the request fails.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
+ (FlybitsRequest * _Nonnull)set:(double)value double:(NSString * _Nonnull)key forKey:(void (^ _Nonnull)(NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



@class NSURLRequest;
enum FlybitsRequestType : NSInteger;
@class NSHTTPURLResponse;
@class NSData;
@class NSURLResponse;

/// The base Flybits SDKs network request class.
SWIFT_CLASS("_TtC10FlybitsSDK14FlybitsRequest")
@interface FlybitsRequest : NSObject
/// Constructs a new request based on an NSURLRequest.
/// \param request An NSURLRequest object.
///
- (nonnull instancetype)initWithRequest:(NSURLRequest * _Nullable)request requestType:(enum FlybitsRequestType)type isCachable:(BOOL)isCachable error:(NSError * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Sets success status code
- (FlybitsRequest * _Nonnull)setHttpSuccessStatusCode:(NSInteger)httpSuccessStatusCode SWIFT_WARN_UNUSED_RESULT;
/// Sets success status code with lower..<upper bounds
- (FlybitsRequest * _Nonnull)setHttpSuccessStatusCodeWithLowerBound:(NSInteger)lower upperBound:(NSInteger)upper SWIFT_WARN_UNUSED_RESULT;
/// Uses Generics to serialize the server’s response into an object of the specified type.
/// \param completion A closure that returns the original request, the response, the serialized object and an error.
///
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
- (nonnull instancetype)responseWithCompletion:(void (^ _Nonnull)(NSURLRequest * _Nullable, NSHTTPURLResponse * _Nullable, NSData * _Nullable, NSError * _Nullable))completion;
/// Uses the <code>uploadTask</code> to place an operation in the OS to be executed later
///
/// returns:
/// A cancellable <code>FlybitsRequest</code> object.
- (nonnull instancetype)uploadTask:(void (^ _Nonnull)(NSData * _Nullable, NSURLResponse * _Nullable, NSError * _Nullable))completion SWIFT_WARN_UNUSED_RESULT;
@end


/// The base Flybits SDK network request list class that handles multiple requests.
SWIFT_CLASS("_TtC10FlybitsSDK18FlybitsRequestList")
@interface FlybitsRequestList : FlybitsRequest
/// Default initializer
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithRequest:(NSURLRequest * _Nullable)request requestType:(enum FlybitsRequestType)type isCachable:(BOOL)isCachable error:(NSError * _Nullable)error SWIFT_UNAVAILABLE;
@end

/// A list of possible request types for a Requestable.
typedef SWIFT_ENUM(NSInteger, FlybitsRequestType, open) {
/// A core request (inherent to Flybits core, i.e. <code>Content</code>, <code>User</code>)
  FlybitsRequestTypeGateway = 0,
/// A rule request (<code>Rule</code> based requests)
  FlybitsRequestTypeRules = 1,
/// A context data update request
  FlybitsRequestTypeContextUpdate = 2,
/// A push request (<code>APNS</code> and <code>MQTT</code> based requests)
  FlybitsRequestTypePush = 3,
/// A custom request
  FlybitsRequestTypeCustom = 4,
};


/// An enum containing different types of request methods. Currently supports <code>GET</code>, <code>POST</code>, <code>PUT</code> and <code>DELETE</code>
typedef SWIFT_ENUM(NSInteger, HTTPMethod, open) {
/// HTTP GET.
  HTTPMethodGET = 0,
/// HTTP POST.
  HTTPMethodPOST = 1,
/// HTTP PUT.
  HTTPMethodPUT = 2,
/// HTTP DELETE.
  HTTPMethodDELETE = 3,
};




/// Defines errors that can occur when fetching a new JWT.
typedef SWIFT_ENUM(NSInteger, JWTError, open) {
/// Max retries
  JWTErrorMaxRetries = 0,
};
static NSString * _Nonnull const JWTErrorDomain = @"FlybitsSDK.JWTError";


/// The <code>JwtIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// can be logged into using the Flybits Token.
SWIFT_CLASS("_TtC10FlybitsSDK6JwtIDP")
@interface JwtIDP : NSObject <IDP>
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// The Request Headers in case any header is necessary to be inserted
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nonnull requestHeaders;
/// Which HTTP method should be used
@property (nonatomic, readonly) enum HTTPMethod requestMethod;
- (void)didAuthenticateWithUser:(User * _Nonnull)user;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>JwtLoginIDP</code> class is responsible for creating an JWT based signed login idnentifier provider (IDP).
/// Using this IDP for customer that need JWT based signed Login indentifier.
/// By using this IDP, customer need to provide a signed JWT.
SWIFT_CLASS("_TtC10FlybitsSDK11JwtLoginIDP")
@interface JwtLoginIDP : NSObject <IDP>
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// Request header need to use jwt signed token
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nonnull requestHeaders;
@property (nonatomic, readonly) enum HTTPMethod requestMethod;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
- (void)encodeWithCoder:(NSCoder * _Nonnull)coder;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines errors that can occur during localization changes
typedef SWIFT_ENUM(NSInteger, LocalizationError, open) {
/// Unknown language code
  LocalizationErrorUnknownLanguageCode = 0,
/// Invalid format
  LocalizationErrorInvalidFormat = 1,
};
static NSString * _Nonnull const LocalizationErrorDomain = @"FlybitsSDK.LocalizationError";

/// Defines some of the error that can be return by Flybits for login related
/// issues. You might get any of those (SessionError, NetworkingRequestError,
/// CoreDataError, etc) as well as LoginError. <code>NSError.userInfo</code> will
/// tell you what data is missing or invalid.
typedef SWIFT_ENUM(NSInteger, LoginError, open) {
/// Missing field/property that is expected to be there for API to function
  LoginErrorMissingRequiredData = 0,
/// Invalid data is being sent for a property – i.e., sending email not in
/// the correct format, i.e., user@flybits,com (notice the comma).
  LoginErrorInvalidData = 1,
/// User already connected. Disconnect before connecting again.
  LoginErrorAlreadyConnected = 2,
/// No user connected. Connect before disconnecting again.
  LoginErrorNotConnected = 3,
};
static NSString * _Nonnull const LoginErrorDomain = @"FlybitsSDK.LoginError";



/// A structure containing many constants used internally in the SDK
SWIFT_CLASS("_TtC10FlybitsSDK7Network")
@interface Network : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Defines all the error that can be return by FlybitsSDK when request fails
/// for network reason, or internal server issues.
/// Note: NetworkingRequestError.FlybitsUnavailable is used as ‘Kill Switch’
typedef SWIFT_ENUM(NSInteger, NetworkingRequestError, open) {
/// Returned data is not the expected format
  NetworkingRequestErrorUnableToParseResponse = 0,
/// Request made is invalid
  NetworkingRequestErrorInvalidRequest = 400,
/// Kill switch – Flybits is deactivated on purpose
  NetworkingRequestErrorFlybitsUnavailable = 503,
/// You do not have access to call the API – may ProjectID is wrong?
  NetworkingRequestErrorUnauthorized = 401,
/// You do not have access to call the API – Are you logged out?
  NetworkingRequestErrorForbidden = 403,
/// Resource is not found – Invalid data is being post to server? or getting from server?
  NetworkingRequestErrorNotFound = 404,
/// Indicates that the application has exceeded its API usage limit for the project.
  NetworkingRequestErrorApiUsageExceeded = 429,
/// Posting data is empty
  NetworkingRequestErrorEmptyData = 430,
/// By default all http request is expected to be between 200 ..< 300 (HTTP success range)
  NetworkingRequestErrorExpectationNotMet = 431,
};
static NSString * _Nonnull const NetworkingRequestErrorDomain = @"FlybitsSDK.NetworkingRequestError";


/// The <code>OAuthIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// is managed by a OAuth based 3rd party integration such Facebook or Google.
SWIFT_CLASS("_TtC10FlybitsSDK8OAuthIDP")
@interface OAuthIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM(NSInteger, SupportedIDP, open) {
/// Facebook OAuth
  SupportedIDPFacebook = 0,
/// Google OAuth
  SupportedIDPGoogle = 1,
/// Okta OAuth
  SupportedIDPOkta = 2,
};


/// The <code>OpenIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// can be logged into using the Open ID connect protocol.
SWIFT_CLASS("_TtC10FlybitsSDK7OpenIDP")
@interface OpenIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC10FlybitsSDK9Operation")
@interface Operation : NSOperation
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (void)observeValueForKeyPath:(NSString * _Nullable)keyPath ofObject:(id _Nullable)object change:(NSDictionary<NSKeyValueChangeKey, id> * _Nullable)change context:(void * _Nullable)context;
@property (nonatomic, readonly, getter=isReady) BOOL ready;
@property (nonatomic, readonly, getter=isExecuting) BOOL executing;
@property (nonatomic, readonly, getter=isFinished) BOOL finished;
@property (nonatomic, readonly, getter=isCancelled) BOOL cancelled;
- (void)addDependency:(NSOperation * _Nonnull)operation;
- (void)main;
- (void)cancel;
- (void)waitUntilFinished;
@end

enum FlybitsUtilitiesSortBy : NSInteger;
enum FlybitsUtilitiesSortOrder : NSInteger;

/// If there are lot of items to be returned, for performance reason, pagination should be used. Even if you do not indicate pagination, response might be paginated.
/// By setting <code>limit</code> and <code>offset</code>, you can retrieve different “pages” of data. For example, you might want to display first 20 items (experiences/content/etc). So, by using pagination as shown below, you will receive the first 20 items.
/// \code
/// // First 20 items or first page with 20 items
/// let pager = Pager(limit:20, offset:0)
///
/// \endcodeTo get the next page or next 20 items:
/// \code
/// // Second 20 items or second page with 20 items
/// let pager = Pager(limit:20, offset:20)
///
/// \endcode
SWIFT_CLASS("_TtC10FlybitsSDK5Pager")
@interface Pager : NSObject
- (nonnull instancetype)initWithLimit:(NSUInteger)limit offset:(NSUInteger)offset totalRecords:(NSUInteger)totalRecords sortBy:(enum FlybitsUtilitiesSortBy)sortBy sortOrder:(enum FlybitsUtilitiesSortOrder)sortOrder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



/// The <code>Project</code> class represents a specific project information
/// for a registered project with Flybits.
SWIFT_CLASS("_TtC10FlybitsSDK7Project")
@interface Project : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC10FlybitsSDK16PushSubscription")
@interface PushSubscription : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



SWIFT_CLASS("_TtC10FlybitsSDK5Query")
@interface Query : NSObject
/// Override to pretty-print the <code>Query</code>’s debug description.
@property (nonatomic, readonly, copy) NSString * _Nonnull debugDescription;
/// Override to pretty-print the <code>Query</code>’s description.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines errors that can occur when creating query to fetch data from server.
typedef SWIFT_ENUM(NSInteger, QueryExpressionError, open) {
/// Not supported
  QueryExpressionErrorUnsupported = 0,
};
static NSString * _Nonnull const QueryExpressionErrorDomain = @"FlybitsSDK.QueryExpressionError";

/// Defines some of the error that can be return by Flybits when registered
/// new user. You might get any of those (SessionError, NetworkingRequestError,
/// CoreDataError, etc) as well as RegistrationError. <code>NSError.userInfo</code> will
/// tell you what data is missing or invalid.
typedef SWIFT_ENUM(NSInteger, RegistrationError, open) {
/// Missing field/property that is expected to be there for API to function
  RegistrationErrorMissingRequiredData = 0,
/// Invalid data is being sent for a property – i.e., sending email not in
/// the correct format, i.e., user@flybits,com (notice the comma).
  RegistrationErrorInvalidData = 1,
/// The server failed to send a confirmation email.
  RegistrationErrorFailedSendingConfirmationEmail = 2,
/// The user tried logging in but is still required to click the
/// confirmation link in their email.
  RegistrationErrorConfirmationRequired = 3,
};
static NSString * _Nonnull const RegistrationErrorDomain = @"FlybitsSDK.RegistrationError";


/// The <code>SharedElements</code> class is responsible for managing various session based information
/// that can be shared across Flybits SDKs.
SWIFT_CLASS("_TtC10FlybitsSDK14SharedElements")
@interface SharedElements : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



/// The <code>SignedIDP</code> class is responsible for creating a specific Identity Provider (IDP) that
/// can be logged into using the SAML protocol.
SWIFT_CLASS("_TtC10FlybitsSDK9SignedIDP")
@interface SignedIDP : NSObject <IDP>
/// The Identity Provider name.
@property (nonatomic, readonly, copy) NSString * _Nonnull provider;
/// The URL Endpoint for the IDP to successfully connect.
@property (nonatomic, readonly, copy) NSString * _Nonnull authenticationEndPoint;
/// The HTTP(s) POST request body for connecting.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestBody;
/// NSCoding decode initializer
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder;
/// NSCoding encode
- (void)encodeWithCoder:(NSCoder * _Nonnull)aCoder;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Defines errors that can occur when using toDictionary.
typedef SWIFT_ENUM(NSInteger, ToDictionaryError, open) {
/// Invalid Coordinate
  ToDictionaryErrorInvalidCoordinate = 0,
/// Invalid Dictionary
  ToDictionaryErrorInvalidDictionary = 1,
};
static NSString * _Nonnull const ToDictionaryErrorDomain = @"FlybitsSDK.ToDictionaryError";


/// The <code>User</code> class represents a specific user and is used to store information
/// about a person who has registered an account with Flybits.
SWIFT_CLASS("_TtC10FlybitsSDK4User")
@interface User : NSObject
/// Compares two <code>User</code>s for equality.
/// \param object Another <code>User</code> (<code>NSObject.isEqual()</code> is used if object is not a <code>User</code>).
///
///
/// returns:
/// <code>true</code> if two <code>User</code>s have the same <code>id</code>, <code>false</code> otherwise.
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// The <code>User</code>’s hash value (used when treated as an <code>NSObject</code>).
@property (nonatomic, readonly) NSUInteger hash;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>UserPreference</code> class represents an object that is used to store user-scoped information
SWIFT_CLASS("_TtC10FlybitsSDK14UserPreference")
@interface UserPreference : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A set of utilities to access common iOS properties.
SWIFT_CLASS_NAMED("Utilities")
@interface FlybitsUtilities : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface FlybitsUtilities (SWIFT_EXTENSION(FlybitsSDK))
@end

/// Sort order allows to sort Content based on different fields.
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesSortOrder, "SortOrder", open) {
/// Results should be sorted in <code>Ascending</code> order
  FlybitsUtilitiesSortOrderAscending = 0,
/// Results should be sorted in <code>Descending</code> order
  FlybitsUtilitiesSortOrderDescending = 1,
};

/// Sort by allows to sort and order Content based on different fields.
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesSortBy, "SortBy", open) {
/// Results should be ordered by Content’s priority index
  FlybitsUtilitiesSortByPriority = 0,
/// Results should be ordered by the time the Content associated rule was last evaluated
  FlybitsUtilitiesSortByEvaluatedAt = 1,
/// Results should be ordered by the time the Content was created
  FlybitsUtilitiesSortByCreatedAt = 2,
/// Results should be ordered by the time the Content was last modified
  FlybitsUtilitiesSortByModifiedAt = 3,
};

/// Length units
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesLengthUnit, "LengthUnit", open) {
/// Units in meters
  FlybitsUtilitiesLengthUnitMeters = 0,
/// Units in miles
  FlybitsUtilitiesLengthUnitMiles = 1,
/// Units in kilometers
  FlybitsUtilitiesLengthUnitKilometers = 2,
/// Units in yards
  FlybitsUtilitiesLengthUnitYards = 3,
/// Units in feet
  FlybitsUtilitiesLengthUnitFeet = 4,
};

/// Time units
typedef SWIFT_ENUM_NAMED(NSInteger, FlybitsUtilitiesTimeUnit, "TimeUnit", open) {
/// Seconds unit
  FlybitsUtilitiesTimeUnitSeconds = 1,
/// Minutes unit
  FlybitsUtilitiesTimeUnitMinutes = 60,
/// Hours unit
  FlybitsUtilitiesTimeUnitHours = 3600,
/// Days unit
  FlybitsUtilitiesTimeUnitDays = 86400,
};

#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#endif
